
@extends('layouts.plantilla')
@section('content')


<div class="container">
  

  <div class="card text-center" ">
    <div class="card-header">
      <center><h4>CONSULTA DE <B>AGREMIADOS</B></h4></center>
    </div>
    <div class="card-body">
      <h5 class="card-title">Búsqueda por DNI</h5>
<form id="buscarForm">
    <input type="text" id="dniInput" name="dni" placeholder="Ingrese el DNI" class="form-control" aria-describedby="basic-addon2">
    <br><button type="submit" class="btn btn-dark">Buscar</button>
</form>
</div>
<div class="card-footer text-muted" id="fechaActual">
  Actualizado: <span id="fecha"></span>
</div>
</div>
</div>
<div class="col-lg-3"></div>

<div class="container">
  
  <div id="resultado"></div>
</div>

<!-- Modal -->
<div id="registroEncontradoModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="registroEncontradoModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="registroEncontradoModalLabel">REGISTRO ENCONTRADO</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Cierre esta ventana para visualizar su certificado</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<div id="registroNoEncontradoModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="registroNoEncontradoModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="registroNoEncontradoModalLabel">REGISTRO NO ENCONTRADO</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>Revise los datos ingreados y vuelva a intentarlo.</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>




@endsection

@section('js')
<script>
  // Obtener el elemento donde se mostrará la fecha
  const fechaElement = document.getElementById('fecha');

  // Obtener la fecha actual
  const fechaActual = new Date();

  // Opciones para formatear la fecha
  const opcionesFecha = { day: 'numeric', month: 'long', year: 'numeric' };

  // Formatear la fecha
  const fechaFormateada = fechaActual.toLocaleDateString('es-ES', opcionesFecha);

  // Mostrar la fecha en el elemento
  fechaElement.textContent = fechaFormateada;
</script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script
  src="https://code.jquery.com/jquery-3.7.0.min.js"
  integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g="
  crossorigin="anonymous"></script>
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>


 <script src="{{asset('js/extranet/agremiado/index.js')}}"></script> 

@endsection