<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PostController;
use App\Http\Controllers\BuscadorController;
use App\Http\Controllers\ScrapeadorController;
use Goutte\Client;
use Symfony\Component\DomCrawler\Crawler;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\PDFController;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/consultar-certificado', function (Request $request) {
    $fCertificado = $request->input('f_certificado');
    $fTipo = $request->input('f_tipo');
    $fMaterno = $request->input('f_materno');
    $fDni = $request->input('f_dni');

    // Realizar la consulta a la API externa
    $response = Http::get('https://intranet.capregionalpuno.org.pe/service/externo/consulta_certificado', [
        'f_certificado' => $fCertificado,
        'f_tipo' => $fTipo,
        'f_materno' => $fMaterno,
        'f_dni' => $fDni,
    ]);

    // Obtener el objeto de la respuesta de la API
    $resultado = $response->json();

    return view('consulta')->with('resultado', $resultado);
});



//api busqueda de colegiados
Route::get('/buscar', [ApiController::class, 'mostrarBuscador']);
Route::get('/buscar-datos/{dni}', [ApiController::class, 'buscarDatos']);

//api funcional de busqueda de colegiados(Ref)
Route::get('/obtener-datos', [ApiController::class, 'obtenerDatos']);

//generar certificado
Route::get('/generar-pdf', [PDFController::class, 'showForm'])->name('generar.pdf.form');
Route::get('/generar-pdf/{curso}/{tipo}/{dni}', [PDFController::class, 'generarPDF'])->name('generar.pdf');
//Route::get('/generar-pdf', 'PDFController@generatePDFUrl')->name('generar.pdf.form');

//Route::get('/generar-pdf/{curso}/{tipo}/{dni}', 'PDFController@generarPDF')->name('generar.pdf');







Route::get('/consulta-colegiado', [ApiController::class, 'consultaColegiado'])->name('consulta.colegiado');




/* Route::group(['middleware' => ['cors']], function () {
    Route::get('/consulta-colegiado', [ApiController::class, 'consultaColegiado'])->name('consulta.colegiado');
}); */




Route::get('posts',\App\Http\Controllers\PostController::class . '@index');
Route::get('posts/store', [PostController::class, 'store']);
Route::get('posts/update', [PostController::class, 'update']);
Route::get('posts/delete', [PostController::class, 'delete']);

/* Route::get('scrapeador', [ScrapeadorController::class, 'index']); */




Route::get('/buscar/{dni}', [App\Http\Controllers\BuscadorController::class, 'buscar']);
/* Route::get('buscar', [App\Http\Controllers\BuscadorController::class, 'buscar']); */

Route::get('/mostrar-parte-especifica', [ScrapeadorController::class, 'mostrarParteEspecifica']);






Route::get('/', function () {
    return view('welcome');
});
